



/******************************************************************************************
 *                                                                                        *
 *                                                                                        *
 *  Ex2.     :  Read ASCII ET-Matrix Key Decoder for Key PAD 4x4 and 4x3                  *
 *                  (Connect Key Pad 4x4 or 4x3 to KEY_IN1 or KEY_IN2)                    *              
 *                                                                                        *
 *                                                                                        *
 ******************************************************************************************
 *                                                                                        *
 * Target MCU     : ATMEL AT89C51RE2                                                      *
 *       	      : X-TAL : 18.432 MHz                                                    *
 *                                                                                        *
 * Keil Editor    : uVision3 V3.62C                                                       *
 * Compiler       : Keil C51 (V9.51)                                                      *
 *                                                                                        *
 * Create By         : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                               *
 * Last Update       : 13/April/2015                                                      *
 *                                                                                        *
 *                                                                                        * 
 * O/P Display Port  :                                                                    *
 *                                                                                        *
 *               LED : Connect Common Anode(LED Active Low)                               *
 *                     P0[0..7]              Connect                   LED0..LED7         *
 *                                                                                        *
 *                                                                             5V         *
 *                                                                             -+-        *
 *                                                              560      \\     |         *
 *                                                      P0.0 --/\/\/\---|<|-----+         *
 *                                                                      .       |         *
 *                                                              560     . \\    |         *
 *                                                      P0.7 --/\/\/\-----|<|---+         *
 *                                                                                        *
 *                                                                                        *
 *  RS232#1 UART0   : P3.1 = TX0          Connect         Rx ET-Matrix Key Decoder        *
 *                    P3.0 = RX0          Connect         Tx ET-Matrix Key Decoder        *                                                                        *
 *                    Baud Rate = 57600  at Clock 18.432 Mhz (6 Clock)                    *
 *                                                                                        *
 *                                                                                        *
 * Operation  : When Press Key will :                                                     *
 *                                      -Show ASCII(Hex) Key Code (Key0-F) To LED         *                                                                             
 *                                                                                        *
 ******************************************************************************************/

#include <at89c51xd2.h>            /* AT89C51xD2 definitions                      */
#include <stdio.h>                 /* prototype declarations for I/O functions     */
                         
char key[3] ,n=0                    ;


//******** Interrupt Service Receive DATA UART0 **********
//********************************************************

void Rx_data() interrupt 4 
  {
	  if(RI == 1)	                          //If Flag RI =  1 is INT.form Rx
	  {
		 key[n]    = SBUF                  ;  //Step1: Read ASCII Code 3 Byte
		 RI = 0							   ;  //Clear Flag
		 n++                               ;  //Pointer Array	  

		 if(n == 3)			               	  //if Pointer= 3 Clear Pointer=0
			n=0                            ;
	
      }	 //if IR 
   }


//*************************** Main *************************

void main (void) 
 {                               
 
     CKCON0 = 0x01   ;  //div 6 clk mode  X2=1
     AUXR   = 0x10   ;  //Set XRAM = 1792 Byte
 
	
   //---------initial Uart0 ------------

    BRL     = 0xEC  ;  // Baud Rate 57600
    PCON   |= 0x80  ;  // Set SMOD1=1 :Double BR  
   
    BDRCON  = 0x1E  ;  // Select Internal Baud-Rate,enable,0x1E=Fast BR. //0x1C=No fast BR.	 
    SCON    = 0x50  ;  // Serial Mode1:8bit Uart,enable serial ,Clear Flag Rx/Tx 	   
    ES      = 0     ;  // Disable Serial Uart  Interrupt    
  
    TI=1            ;
    
	  
    ES = 1          ;  //Enable Serial Uart Interrupt 
    EA = 1          ;  //Enable global Interrupt 
  

    
    //---------------- Main -----------------
     while(1)
       {
        if(key[2] == 0x0D)                    //Step2: Check data Last Byte = Enter ?            
         {
           key[2] = 0 ;                       //Step3: Clear data in buffer array key[2]
         
           if(key[0]=='P')                    //Step4: Check  Status  Pressed key (ASCII Code = 'P')
            {
             //------ Step5 : Write Program Support Press Key of User ------ 
                      
             P0 = ~key[1]               ;     //Out data key Code to LED P0[0..7]
            
             while(key[0] != 'R') {;}         //wait Release Key (when key[0]=R) for Exit Loop   
           
             P0 = 0xFF                  ;     //Clear LED PORT P0 
           }
         }  //if key[2]    
       } //while
 
  }






 